#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <curses.h>
//#include <term.h>

void anykey() {
	addstr("\nPress any key to continue...\n\n");
	refresh();
	getch();
}

void quit(void) {
  	endwin();
}

void printSpaces(int width) {
	int j;
	for (j = 0; j < width+10; j++) {
		addstr(" ");
	}
}

void printFloor(int width) {
	int j;
	color_set(3, 0);
	for (j = 0; j < width+8; j++) {
		addstr("-");
	}
	color_set(1, 0);
	addstr("[   ]");
	color_set(3, 0);
	for (j = width+1; j < width*2+10; j++) {
		addstr("-");
	}
}

void cleanPos(int *ballsPos) {
	int i;
	for (i = 0; i < 160; i++) {
		ballsPos[i] = 0;
	}
}

int main(int args, char **argsv) {
	//SCREEN *s = newterm(NULL, stdin, stdout);

	WINDOW *mywin = initscr();
	atexit(quit);
	start_color();
	clear();
	refresh();
	init_pair(1, COLOR_GREEN, COLOR_BLACK);
	init_pair(2, COLOR_RED, COLOR_BLACK);
	init_pair(3, COLOR_WHITE, COLOR_BLACK);
	init_pair(4, COLOR_YELLOW, COLOR_BLACK);
	color_set(3, 0);

	int height, balls, width;
	int i, j;
	int ballsPerRow[80];
	int ballsPos[160];
	int r;
	int leftorright = 0;

	if (args < 3) {
		addstr("Usage: weihnachtsbaum height balls \nWhere:\n  ...height is the height of your Christmas tree.\n  ...balls is the number of balls on it.\n\n");
		anykey();
		return(1);
	}

	height = atoi(argsv[1])-1;
	balls = atoi(argsv[2]);

	if (height > 79) {
		addstr("Man, that's way too high! Trees may only be 80 feet high!\n");
		anykey();
		return(2);
	}
	if (height < 5) {
		addstr("Aye, mate, that's a wee little tree you're trying to build! Should be a wee bit bigger!\n");
		anykey();
		return(2);
	}
	if (balls > ((height)*(height+1))/2) {
		addstr("You have too many balls! I mean, they won't fit. Onto the tree. All of them. At least not at once!\n");
		anykey();
		return(3);
	}

	//printf("Will generate a Christmas tree of height %i with %i balls. Please stand by! ;-)\n", height+1, balls);

	for (i = 0; i < 80; i++) {
		ballsPerRow[i] = 0;
	}
	srand(time(NULL));
	for (i = 0; i < balls; i++) {
		r = (int)((float)(height)*rand()/(RAND_MAX+1.0)+1);
		//printf("%i=%i,",i, r);
		if (ballsPerRow[r] < r) {
			ballsPerRow[r]++;
		} else {
			i--;
		}
	}
	/*for (i = 0; i < height+1; i++) {
		printf("\n%i", ballsPerRow[i]);
	}*/
	clear();
	addstr("\n");
	color_set(4, 0);
	printSpaces(height);
	addstr("\\ /\n");
	printSpaces(height-2);
	addstr("~~>*<~~\n");
	printSpaces(height);
	color_set(1, 0);
	addstr("/_\\\n");

	for (i = 1; i < height+1; i++) {
		width = height - i;
		printSpaces(width);
		color_set(1, 0);
		addstr("/_");
		//printf("%i\n", ballsPerRow[i]);
		cleanPos(ballsPos);
		for (j = 0; j<ballsPerRow[i]; j++) {
			r = (int)((float)i*rand()/RAND_MAX+1.0)-1;
			if (ballsPos[r] == 0) {
				ballsPos[r] = 1;
			} else {
				j--;
			}
			//printf("%i,%i\n", r, ballsPos[r]);
		}
		for (j = 0; j<i; j++) {
			if (ballsPos[j] == 0) {
				color_set(1, 0);
				if (leftorright) {
					addstr("\\");
				} else {
					addstr("/");
				}
			} else {
				color_set(2, 0);
				r = (int)(4.0*rand()/(RAND_MAX+1.0));
				if        (r == 0) {
					addstr("i");
				} else if (r == 1) {
					addstr("O");
				} else if (r == 2) {
					addstr("o");
				} else {
					addstr("@");
				}
			}
			if (j != i) {
				color_set(1, 0);
				addstr("_");
			}
		}
		addstr("\\\n");
		leftorright = (++leftorright) % 2;
	}
	printSpaces(height-1);
	addstr("[   ]\n");
	printFloor(height+1);
	addstr("\n\n Iteration:\n Press q to quit!\n");
	refresh();

	char buffer[42];
	char testfortree = 0;
	int realHeight = height + 6;
	int realWidth = height*2 + 22;
	int snowFlakesX[80], snowFlakesY[80];
	for (i = 0; i < 80; i++) {
		snowFlakesX[i] = -1;
		snowFlakesY[i] = 0;
	}
	int numofflakes = realWidth / 2;
	if (numofflakes > 80) numofflakes = 80;
	j = 0;
	color_set(3, 0);

    nodelay(mywin, TRUE);
    char keypress = '#';
	while (keypress == '#') {
		j++;
		for (i = 0; i < numofflakes; i++) {
			if ((snowFlakesX[i] == -1) && ((int)(5.0*rand()/RAND_MAX+1.0) == 1)) {
				r = (int)((float)realWidth*rand()/RAND_MAX+1.0);
				snowFlakesX[i] = r;
				snowFlakesY[i] = 0;
				mvaddstr(snowFlakesY[i], snowFlakesX[i], "*");
			} else {
				testfortree = mvinch((snowFlakesY[i]+1), snowFlakesX[i]) & A_CHARTEXT;
				if ((snowFlakesY[i] >= (realHeight-1)) || ((testfortree != ' ') && (testfortree != '*') && (testfortree != '-'))) {
					snowFlakesX[i] = -1;
				} else {
					mvaddstr(snowFlakesY[i], snowFlakesX[i], " ");
					snowFlakesY[i]++;
					mvaddstr(snowFlakesY[i], snowFlakesX[i], "*");
				}
			}
			sprintf(buffer, "%i\n", i);
			//mvaddstr(1, 1, buffer);
		}
		refresh();
		sprintf(buffer, "%6i", j);
		mvaddstr(realHeight+1, 11, buffer);
		usleep(100000);
		//sleep(1);
		keypress = getch();
		if ((keypress != 'q') && (keypress != 'x')) keypress = '#';
	}
	return(0);
}



















